// This is a MiniMod Macro-Plugin.
// Due to the nature of this plugin it cannot be broken down into inividual plugins.
//
// This is the set of armors and weapons from the Ideal Mod.
// Note: At the time of this plugin's release, MiniMod v.03~v.05 only supports this
//  kind of plugin in the most "BETA'ish" form. If you are not a good scriptor it is
//  NOT recommended that you play with these.
//
// Unless Macro-plugins are ported in a EXTREMELY articulate manner they cause
//  massive amounts of clashing with other plugins!!!

# Damage Types
#
$ImpactDamageType	     = -1;
$LandingDamageType      =  0;
$BulletDamageType      =  1;
$EnergyDamageType      =  2;
$PlasmaDamageType      =  3;
$ExplosionDamageType   =  4;
$ShrapnelDamageType    =  5;
$LaserDamageType       =  6;
$MortarDamageType      =  7;
$BlasterDamageType     =  8;
$ElectricityDamageType =  9;
$CrushDamageType       = 10;
$DebrisDamageType      = 11;
$MissileDamageType     = 12;
$MineDamageType        = 13;
$LCGDamageType         = 14;
$NoDamageType	     = 15;
$SlowDamageType	     = 16;
$MarlinDamageType      = 17;
$StunDamageType        = 18;
$DecloakDamageType     = 20;
$ConcussionDamageType  = 21;
$JitterbugDamageType   = 22;
$EMPDamageType         = 23;
$ObeliskDamageType     = 24;
$FlameDamageType       = 25;
$SCVDamageType         = 26;

//begin mod
RepairEffectData SCVProjectile
{
   bitmapName       = "repairadd.bmp";
   boltLength       = 20.0;
   segmentDivisions = 4;
   beamWidth        = 0.25;

   updateTime   = 450;
   skipPercent  = 0.6;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.85, 0.25, 0.25 };
};

function SCVProjectile::onAcquire(%this, %player, %target)
{
	%client = Player::getClient(%player);

	if (%target == %player)
	{
	   %player.repairTarget = -1;
		if (GameBase::getDamageLevel(%player) != 0)
		{
			%player.repairRate = 0.05;
			%player.repairTarget = %player;
			Client::sendMessage(%client, 0, "AutoRepair On");
		}
		else
		{
			Client::sendMessage(%client,0,"Nothing in range");
			Player::trigger(%player, $WeaponSlot, false);
			return;
		}
	}
	else
	{
      	%player.repairTarget = %target;
		%player.repairRate   = 0.05;
		if (getObjectType(%player.repairTarget) == "Player")
		{
			%rclient = Player::getClient(%player.repairTarget);
			%name = Client::getName(%rclient);
		}
		else
		{ 
			%name = GameBase::getMapName(%target);
			if(%name == "")
			{
				%name = (GameBase::getDataName(%player.repairTarget)).description;
			}
		}
		if(GameBase::getTeam(%player) == GameBase::getTeam(%player.repairTarget))
		{
			if (GameBase::getDamageLevel(%player.repairTarget) == 0)
			{
				Client::sendMessage(%client,0,%name @ " is not damaged");
				Player::trigger(%player,$WeaponSlot,false);
				%player.repairTarget = -1;
				return;
			}
			if (getObjectType(%player.repairTarget) == "Player")
			{
				Client::sendMessage(%rclient,0,"Being repaired by " @ Client::getName(%client));
			}
			Client::sendMessage(%client,0,"Repairing " @ %name);
		}

	}
	%rate = GameBase::getAutoRepairRate(%player.repairTarget) + %player.repairRate;
	GameBase::setAutoRepairRate(%player.repairTarget,%rate);
}

function SCVProjectile::onRelease(%this, %player)
{
	%object = %player.repairTarget;
	if (%object != -1)
	{
		%client = Player::getClient(%player);
		if (%object == %player)
		{
			Client::sendMessage(%client,0,"AutoRepair Off");
		}
		else if(GameBase::getTeam(%object) == GameBase::getTeam(%player))
		{
			if (GameBase::getDamageLevel(%object) == 0)
			{
				Client::sendMessage(%client,0,"Repair Done");
			}
			else
			{
				Client::sendMessage(%client,0,"Repair Stopped");
			}
		}
		%rate = GameBase::getAutoRepairRate(%object) - %player.repairRate;
      if (%rate < 0)
         %rate = 0;
      
		GameBase::setAutoRepairRate(%object,%rate);
	}
}

function SCVProjectile::checkDone(%this, %player)
{
	if (Player::isTriggered(%player,$WeaponSlot) && Player::getMountedItem(%player,$WeaponSlot) == SCVGun && %player.repairTarget != -1)
	{
		%object = %player.repairTarget;
		if (%object == %player)
		{
			if (GameBase::getDamageLevel(%player) == 0) {
				Player::trigger(%player,$WeaponSlot,false);
				return;
			}
		}
		else if(GameBase::getTeam(%object) == GameBase::getTeam(%player))
		{
			if (GameBase::getDamageLevel(%object) == 0)
			{
				Player::trigger(%player,$WeaponSlot,false);
				return;
			}
		}
		else
		{
			if(getObjectType(%player.repairTarget) == "Player")
			{
				if(Player::isDead(%object))
				{
					Player::trigger(%player,$WeaponSlot,false);
					return;
				}
			}
			else
			{
				if(GameBase::getDamageLevel(%object) == GameBase::getDataName(%object).maxDamage)
				{
					Player::trigger(%player,$WeaponSlot,false);
					return;
				}
			}
			
			%client = Player::getClient(%player);
			GameBase::applyDamage(%object, $SCVDamageType, 0.02, GameBase::getPosition(%object), Item::getVelocity(%player), "0 0 0", Client::getControlObject(%client));

			
			
		}
	}
}


GrenadeData ECMShell
{
   bulletShapeName    = "grenade.dts";
   explosionTag       = grenadeExp;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.2;
   mass               = 1.0;
   elasticity         = 0.15;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.04;
   damageType         = $DecloakDamageType;

   explosionRadius    = 15;
   kickBackStrength   = 150.0;
   maxLevelFlightDist = 150;
   totalTime          = 30.0;    // special meaning for grenades...
   liveTime           = 1.0;
   projSpecialTime    = 0.05;

   inheritedVelocityScale = 0.5;

   smokeName              = "smoke.dts";
};



RocketData FlamePlasma
{
   bulletShapeName  = "plasmabolt.dts";
   explosionTag     = fireExp;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.025;
   damageType       = $FlameDamageType;

   explosionRadius  = 3.0;
   kickBackStrength = 5.0;
   muzzleVelocity   = 65.0;
   terminalVelocity = 80.0;
   acceleration     = 5.0;
   totalTime        = 0.2;
   liveTime         = 2.0;
   lightRange         = 10.0;
   lightColor         = { 1, 1, 0 };
   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "plasmabolt.dts";
   smokeDist   = 25.0;

   soundId = SoundJetHeavy;
};

SeekingMissileData HomingDiscShell
{
   bulletShapeName = "discb.dts";
   explosionTag    = rocketExp;

   collisionRadius = 0.0;
   mass            = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0.1667;
   damageType       = $ExplosionDamageType;

   explosionRadius  = 5.0;
   kickBackStrength = 50.0;

   muzzleVelocity    = 72.0;
   totalTime         = 10;
   liveTime          = 10;
   seekingTurningRadius    = 10.0;
   nonSeekingTurningRadius = 75.0;
   proximityDist     = 1.5;
   smokeDist         = 1.75;


   lightRange       = 5.0;
   lightColor       = { 0.4, 0.4, 1.0 };

   inheritedVelocityScale = 0.5;

   // rocket specific
   trailType   = 1;
   trailLength = 30;
   trailWidth  = 0.2;

   soundId = SoundDiscSpin;
};



BulletData SuperBlasterBolt
{
   bulletShapeName    = "fusionex.dts";
   explosionTag       = turretExp;

   damageClass        = 0;
   damageValue        = 0.75;
   damageType         = $BlasterDamageType;

   muzzleVelocity     = 200.0;
   totalTime          = 2.0;
   liveTime           = 1.125;

   lightRange         = 3.0;
   lightColor         = { 0.25, 0.25, 1.0 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

   rotationPeriod = 1;
};

BulletData OtherBlasterBolt
{
   bulletShapeName    = "enbolt.dts";
   explosionTag       = energyExp;

   damageClass        = 0;
   damageValue        = 0.25;
   damageType         = $BlasterDamageType;

   muzzleVelocity     = 200.0;
   totalTime          = 2.0;
   liveTime           = 1.125;

   lightRange         = 3.0;
   lightColor         = { 0.25, 0.25, 1.0 };
   inheritedVelocityScale = 0.5;
   isVisible          = True;

   rotationPeriod = 1;
};
RepairEffectData targetpull
{
   bitmapName       = "repairadd.bmp";
   boltLength       = 50.0;
   segmentDivisions = 1;
   beamWidth        = 0.125;

   updateTime   = 450;
   skipPercent  = 0.6;
   displaceBias = 0.15;

   lightRange        = 2.0;
   lightColor        = { 0.25, 1.0, 0.25 };
};

function targetpull::pull(%client, %rclient)
{

	%myPos = GameBase::getPosition(%client);
	%yourPos = GameBase::getPosition(%rclient);
	%myRot = GameBase::getRotation(%client);

	%dir = getWord(%myRot, 0) @ " " @ getWord(%myRot, 1) @ " " @ 3.14 + getWord(%myRot, 2); //make dir face opposite direction, thus pulls toward

	%myFlatPos = getWord(%myPos, 0) @ " " @ getWord(%myPos, 1) @ " 0";
	%yourFlatPos = getWord(%yourPos, 0) @ " " @ getWord(%yourPos, 1) @ " 0";

	%dist = Vector::getDistance(%myFlatPos, %yourFlatPos); //so Z isn't in distance & doesn't make you go FLYING if you have a huge height difference
	if(%dist) //just in case, avoid divide by zero
		%force = 2000 / %dist; //gets smaller as the distance increases

	%height = 10 * (getWord(%myPos, 2) - getWord(%yourPos, 2)); //diff in z-values

echo("dir = " @ %dir @ " dist = " @ %dist @ " hi = " @ %height);

	%diffVector = Vector::getFromRot(%dir, %force, %height);

echo("%diffvector = " @ %diffVector);

	Player::applyImpulse(%rclient, %diffVector);


}

function targetpull::onAcquire(%this, %player, %target)
{
	%client = Player::getClient(%player);

	%player.tractorTarget = %target;

	if (%target == %player || getObjectType(%player.tractorTarget) != "Player")
	{
		Client::sendMessage(%client,0,"No one in range");
		Player::trigger(%player, $WeaponSlot, false);
		return;
	}

	%rclient = Player::getClient(%player.tractorTarget);

	Client::sendMessage(%rclient,0,"Being tractored in by " @ Client::getName(%client));
	Client::sendMessage(%client,0,"Pulling on " @ Client::getName(%rclient));

	targetpull::pull(%client, %rclient);
}

function targetpull::onRelease(%this, %player)
{
	%object = %player.tractorTarget;
	if (%object != -1)
	{
		%client = Player::getClient(%player);
		if (%object == %player || getObjectType(%object) != "Player")
		{
			return;
		}

		Client::sendMessage(%client,0,"Tractor Beam Stopped");
	}
}


function targetpull::checkDone(%this, %player)
{
	if (Player::isTriggered(%player,$WeaponSlot) && Player::getMountedItem(%player,$WeaponSlot) == TractorBeam && %player.tractorTarget != -1)
	{
		%object = %player.tractorTarget ;

		%myPos = GameBase::getPosition(%player);
		%yourPos = GameBase::getPosition(%object);

		%myFlatPos = getWord(%myPos, 0) @ " " @ getWord(%myPos, 1) @ " 0";
		%yourFlatPos = getWord(%yourPos, 0) @ " " @ getWord(%yourPos, 1) @ " 0";

		if(Vector::getDistance(%myFlatPos, %yourFlatPos) < 3.0)
		{
			Player::trigger(%player,$WeaponSlot,false);
			return true;
		}
		else
		{
			targetpull::pull(Player::getClient(%player), Player::getClient(%player.tractorTarget));
		}
		return false;
	}

	return true;
}






BulletData Decloak
{
   bulletShapeName    = "breath.dts";
   explosionTag       = bulletExp0;
   mass               = 0.03;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.0;
   damageType         = $DecloakDamageType;

   muzzleVelocity     = 2000.0;
   totalTime          = 1.5;
   inheritedVelocityScale = 1.0;

   liveTime           = 4.0;
   isVisible          = False;

   rotationPeriod = 1.5;
};

GrenadeData EMPMortarShell
{
   bulletShapeName    = "mortar.dts";
   explosionTag       = RandomShockwave;
   collideWithOwner   = True;
   ownerGraceMS       = 250;
   collisionRadius    = 0.3;
   mass               = 5.0;
   elasticity         = 0.1;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0.1;
   damageType         = $EMPDamageType;

   explosionRadius    = 20.0;
   kickBackStrength   = 0.15;
   maxLevelFlightDist = 275;
   totalTime          = 30.0;
   liveTime           = 2.0;
   projSpecialTime    = 0.01;

   inheritedVelocityScale = 0.5;
   smokeName              = "fusionbolt.dts";
};


BulletData Marlinshot
{
   bulletShapeName    = "bullet.dts";
   explosionTag       = bulletExp0;
   mass               = 0.03;

   damageClass        = 0;       // 0 impact, 1, radius
   damageValue        = 0.61;
   damageType         = $MarlinDamageType;

   muzzleVelocity     = 800.0;
   totalTime          = 1.5;
   inheritedVelocityScale = 1.0;

   liveTime           = 4.0;
   isVisible          = True;

   rotationPeriod = 1.5;
};



LaserData LaserChain
{
   laserBitmapName   = "laserPulse.bmp";
   hitName           = "laserhit.dts";

   damageConversion  = 0.015;
   damageType    = $LCGDamageType;

   beamTime          = 0.5;
   lightRange        = 2.0;
   lightColor        = { 1.0, 0.25, 0.25 };

   detachFromShooter = false;
   hitSoundId        = SoundLaserHit;
};

BulletData SlowPod
{
   bulletShapeName    = "mortar.dts";
   explosionTag       = plasmaExp;
   mass               = 6.0;

   damageClass        = 1;       // 0 impact, 1, radius
   damageValue        = 0;
   damageType         = $SlowDamageType;
   isvisible          = true;
   muzzleVelocity     = 35.0;
   explosionRadius    = 7.5;
   kickBackStrength   = 0.25;
   maxLevelFlightDist = 300;
   totalTime          = 30.0;

   inheritedVelocityScale = 0.25;
};



RocketData concussShot
{
   bulletShapeName  = "plasmawall.dts";
   explosionTag     = RandomShockwave;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue    = 0;
   damageType       = $ConcussionDamageType;

   explosionRadius  = 125;
   kickBackStrength = 250.0;
   muzzleVelocity   = 100.0;
   terminalVelocity = 300.0;
   acceleration     = 10.0;
   totalTime        = 25.0;
   liveTime         = 26.0;
   lightRange       = 25.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;
	isdestroyable = true;
	maxdamage = 0.01;
   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "rsmoke.dts";
   smokeDist   = 1.8;

   soundId = SoundJetHeavy;
};

RocketData jitterbugShot
  {
   bulletShapeName  = "hflame.dts";
   explosionTag     = shockwave;
   collisionRadius  = 0.0;
   mass             = 2.0;

   damageClass      = 1;       // 0 impact, 1, radius
   damageValue      = 0;
   damageType       = $JitterbugDamageType;

   explosionRadius  = 75;
   kickBackStrength = 50.0;
   muzzleVelocity   = 100.0;
   terminalVelocity = 300.0;
   acceleration     = 10.0;
   totalTime        = 20.0;
   liveTime         = 26.0;
   lightRange       = 25.0;
   lightColor       = { 1.0, 0.7, 0.5 };
   inheritedVelocityScale = 0.5;
	isdestroyable = true;
	maxdamage = 0.01;
   // rocket specific
   trailType   = 2;                // smoke trail
   trailString = "rsmoke.dts";
   smokeDist   = 1.8;

   soundId = SoundJetHeavy;
};


RepairEffectData CloakerBolt
{
   bitmapName       = "repairadd.bmp";
   boltLength       = 5.0;
   segmentDivisions = 4;
   beamWidth        = 0.125;

   updateTime   = 450;
   skipPercent  = 0.6;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.85, 0.25, 0.25 };
};

function CloakerBolt::onAcquire(%this, %player, %target)
{
	if (%target == %player)
	{
		%player.cloakGun = 1;
		if(%player.cloakPack != 1)
			GameBase::startFadeOut(%player);
		%rate = Player::getSensorSupression(%player) + 20;
		if(%rate < 20)
			%rate = 20;
		Player::setSensorSupression(%player,%rate);
		%player.shieldStrength += 0.01;
	}
	else
	{
		GameBase::startFadeOut(%target);
		schedule("GameBase::startFadeIn(" @ %target @ ");", 15);
	}
}

function CloakerBolt::onRelease(%this, %player)
{
	if(%player.cloakGun)
	{
		%player.cloakGun = 0;
		if(%player.cloakPack != 1)
			GameBase::startFadeIn(%player);
		if(%rate < 0)
			%rate = 0;
		%rate = Player::getSensorSupression(%player) - 20;
		Player::setSensorSupression(%player,%rate);
		%player.shieldStrength -= 0.01; 
	}
}

LightningData longlightningCharge
{
   bitmapName       = "lightningNew.bmp";

   damageType       = $ElectricityDamageType;
   boltLength       = 100.0;
   coneAngle        = 135.0;
   damagePerSec      = 0.02;
   energyDrainPerSec = 45.0;
   segmentDivisions = 4;
   numSegments      = 2;
   beamWidth        = 0.375;

   updateTime   = 120;
   skipPercent  = 0.5;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.25, 0.25, 0.85 };

   soundId = SoundELFFire;
};

LightningData shortlightningCharge
{
   bitmapName       = "lightningNew.bmp";

   damageType       = $ElectricityDamageType;
   boltLength       = 15.0;
   coneAngle        = 35.0;
   damagePerSec      = 0.11;
   energyDrainPerSec = 100.0;
   segmentDivisions = 4;
   numSegments      = 8;
   beamWidth        = 0.075;

   updateTime   = 120;
   skipPercent  = 0.5;
   displaceBias = 0.15;

   lightRange = 3.0;
   lightColor = { 0.25, 0.25, 0.85 };

   soundId = SoundELFFire;
};


